/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.bean;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.bean.InstanceMethodIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;

public class InstanceMethodIteratorTest {
    @Test
    public void testGetElements() throws Exception {
        InstanceMethodIterator testInstance = new InstanceMethodIterator(MethodsContainer.class, Object.class);
        HashSet expectedResult = new HashSet(Arrays.asList((Object[])new Method[]{MethodsContainer.class.getDeclaredMethod("method1", new Class[0]), MethodsContainer.class.getDeclaredMethod("method2", new Class[0]), MethodsContainer.class.getDeclaredMethod("method3", new Class[0]), MethodsContainer.class.getDeclaredMethod("method4", new Class[0])}));
        Assertions.assertThat(new HashSet(Iterables.collectToList(() -> testInstance, Function.identity()))).isEqualTo(expectedResult);
    }

    @Test
    public void testNext_throwsNoSuchElementException() {
        InstanceMethodIterator testInstance = new InstanceMethodIterator(MethodsContainer.class, Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InstanceMethodIterator)testInstance).next());
        testInstance = new InstanceMethodIterator(MethodsContainer.class, Object.class);
        testInstance.next();
        testInstance.next();
        testInstance.next();
        testInstance.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InstanceMethodIterator)testInstance).next());
        testInstance = new InstanceMethodIterator(Object.class, Object.class);
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InstanceMethodIterator)testInstance).next());
        testInstance = new InstanceMethodIterator(Object.class, Object.class);
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((InstanceMethodIterator)testInstance).next());
    }

    private static class MethodsContainer {
        private MethodsContainer() {
        }

        private static Object staticMethod1() {
            return null;
        }

        protected static Object staticMethod2() {
            return null;
        }

        public static Object staticMethod3() {
            return null;
        }

        static Object staticMethod4() {
            return null;
        }

        private String method1() {
            return null;
        }

        protected String method2() {
            return null;
        }

        public String method3() {
            return null;
        }

        String method4() {
            return null;
        }
    }
}

